#!/usr/bin/env bash
set -euo pipefail
ROOT="$(cd "$(dirname "$0")" && pwd)"
export FORENSIC_KIT_ROOT="${ROOT}"
export FORENSIC_STATIC_ROOT="${ROOT}/static"
if [[ -f "${ROOT}/proof-rules.enc" ]]; then
  export FORENSIC_RULES_ROOT="${ROOT}/proof-rules.enc"
else
  export FORENSIC_RULES_ROOT="${ROOT}/proof-rules"
fi
# Select the newest LIC_*.signed.json as the license file.
candidate="$(ls -t "${ROOT}"/LIC_*.signed.json 2>/dev/null | head -n1 || true)"
if [[ -n "${candidate}" ]]; then
  export FORENSIC_LICENSE_FILE="${candidate}"
else
  echo "Missing license: expected LIC_*.signed.json in ${ROOT}" >&2
  exit 1
fi
# Default bundle root inside the kit (kept outside manifest)
export FORENSIC_BUNDLE_ROOT="${FORENSIC_BUNDLE_ROOT:-${ROOT}/bundles}"
export FORENSIC_LICENSE_REQUIRED=1
export FORENSIC_BIND="${FORENSIC_BIND:-127.0.0.1:8080}"
mkdir -p "${FORENSIC_BUNDLE_ROOT}"

if [[ $# -eq 0 || "${1:-}" == "serve" ]]; then
  # Default: run the server UI
  if [[ "${1:-}" == "serve" ]]; then
    shift
  fi
  echo "Legacy Lens server starting on ${FORENSIC_BIND}"
  echo "Open http://${FORENSIC_BIND}"
  exec "${ROOT}/legacy-lens-server" "$@"
else
  # CLI path: accept 'analyze' or 'govern' directly
  exec "${ROOT}/legacy-lens" "$@"
fi
