# Simulated Big-4 Audit Review

Audience
- Audit Partner
- Technology Risk Director
- Legal / Independence Reviewer

Objective
Determine whether Legacy Lens outputs can be relied upon as governance evidence without re-performing the analysis.

## 1. Independence and Determinism
Auditor Question 1
How do you ensure results are not influenced by operator judgment or tuning?

Answer
Legacy Lens is deterministic. Given identical inputs, rule registry, and Standard-of-Proof version, outputs are bit-for-bit identical, including cryptographic hashes. Operator input is limited to declared context, which is recorded and does not alter rule behavior.

Auditor Question 2
Can results be replayed years later?

Answer
Yes. Evidence bundles include source hashes, rule registry version, and Standard-of-Proof version. Replay produces identical results or invalidates the run if determinism cannot be met.

## 2. Scope and Non-Claims
Auditor Question 3
Do you certify compliance or security?

Answer
No. Legacy Lens does not certify compliance, security, or runtime behavior. It produces deterministic evidence and records the absence of guarantees where proof is not possible.

Auditor Question 4
What happens when you cannot analyze part of the system?

Answer
Such regions are treated as opaque boundaries. They are explicitly recorded, never inferred, and may affect governance decisions based on declared context.

## 3. Expansion Discipline (PL/I, JCL, CICS, Assembler)
Auditor Question 5
You support multiple artifacts. How do you prevent over-claiming?

Answer
Each artifact is assigned an evidence tier that constrains claims. Mixed-artifact decisions inherit the lowest evidence tier involved. This is enforced in reports and decision logic.

Reference Table
Artifact | Evidence Tier | Can BLOCK
--- | --- | ---
COBOL | High | Yes
PL/I | Medium | Rare
JCL | N/A | No
CICS/IMS | Low | Policy-driven
Assembler | Low | Never alone

Auditor Follow-Up
Why not analyze assembler more deeply?

Answer
Deterministic proof is not possible without assumptions. We refuse to make claims we cannot prove.

## 4. BLOCK / NO-GO Decisions
Auditor Question 6
When do you block a modernization?

Answer
Only when provable guarantees collapse, such as unbounded dynamic control flow or self-modifying logic. BLOCK is rare by design.

Auditor Question 7
Can users suppress findings to get a GO?

Answer
No. Scope exclusions must be explicit, recorded, and leave residual risk. Suppression does not reclassify excluded artifacts as safe.

## 5. Licensing and Authority
Auditor Question 8
How do you prevent unauthorized use or manipulation?

Answer
License issuance is performed offline by the vendor using a signing authority. Customers receive signed artifacts for verification only. License expiration disables future decisions, not historical evidence.

## 6. Final Audit Judgment
Expected conclusion:
"Legacy Lens does not over-assert, is deterministic, records uncertainty explicitly, and can be relied upon as governance evidence without re-performance."
