# Authority Delivery Spec — Locked Outputs

This document is authoritative. Anything not listed here must not exist.
Legacy Lens issues exactly four authoritative documents. Everything else supports them.

## Executive Decision Summary (PDF)
Audience: CIO, CTO, Program Sponsor.

Required contents:
- Decision (GO / NO-GO / REFUSE)
- Declared governance context (environment / regulatory scope / criticality)
- High-level rationale (plain language)
- Determinism and replayability statement
- Evidence bundle ID
- Registry version + hash
- Issuance timestamp
- Refusal rights statement

Must not contain: rule lists, code snippets, technical terminology, remediation, percentages or scores.

## Board Decision Record (PDF)
Audience: Board of Directors, Audit Committee, Risk Committee.

Required contents:
- Formal decision record header
- Decision outcome
- Declared context (locked)
- Refusal authority statement
- Provability limits statement
- Evidence survivability clause
- Registry version + cryptographic hash
- Evidence bundle hash
- Issuance timestamp
- Authority signature block (system-issued)

Must not contain: engineering detail, optimization language, recommendations, forward-looking statements.

## Engineering Evidence Record (PDF)
Audience: Engineering leadership and mainframe SMEs.

Required contents:
- Findings grouped by rule
- Evidence tier per finding (Tier 0 / Tier 1 / Tier 2)
- Boundary definitions
- Snippet references + snippet hashes
- Artifact inventory (COBOL, JCL, CICS, IMS, PL/I, ASM)
- Dependency resolution status

Must not contain: GO/NO-GO framing, risk language, executive summaries, compliance claims.

## Regulatory Evidence Packet (PDF)
Audience: Regulators, external auditors, inspectors general.

Required contents:
- Scope declaration
- What Legacy Lens does not do
- Determinism guarantees
- Context locking explanation
- Refusal mechanics
- Registry governance model
- Evidence survivability statement
- Audit replay instructions
- Cryptographic integrity section

Must not contain: compliance certification, pass/fail claims beyond context, business risk scoring, recommendations.

## Evidence Artifacts (Supporting)
- Verified Findings (JSON)
- Evidence Bundle Manifest (JSON)

These support authority documents but are not authority by themselves.

## Legal / Procurement
Output: Authority Definition Clause (contract section).

Required language: Legacy Lens issues or refuses governance decisions; refusal is successful performance; evidence remains verifiable.
