# Legacy Lens Block Policy Appendix

## Validation Statement (Public Corpora)

Legacy Lens has been validated against multiple publicly available COBOL codebases,
including sample applications, training repositories, and file I/O heavy projects.
Across these corpora, Legacy Lens consistently:

- Executes offline and deterministically (repeat runs produce identical integrity hashes).
- Produces evidence-anchored findings (file, line, snippet, hash).
- Distinguishes source-level guarantees from absence of guarantees.
- Marks boundaries explicitly (dependencies, copybooks, opaque constructs) and does not infer runtime environment behavior.
- Avoids silent skips; unsupported constructs are reported explicitly when encountered.

Validation on public corpora demonstrates determinism, evidence integrity, and
semantic consistency. Public corpora are not representative of any single regulated
production environment. Governance outcomes depend on the declared context.

## Public Corpora Outcomes (Examples)

| Repo / Corpus | Outcome | Why |
| --- | --- | --- |
| AWS CardDemo (Mainframe Modernization) | NO-GO | Contains guarantee-collapse constructs such as ALTER or computed control flow. |
| Legacy Lens Golden Pack (LLGOLD01) | NO-GO (by design) | Includes dynamic CALL, computed GO TO, and ALTER for regression coverage. |
| dsc-gnu-Indexed | GO (no blockers), FLAGs | Missing FILE STATUS and control-flow risks, but no guarantee-collapse constructs. |
| COBOL-Examples / GNUCobol-Samples / Cobol-Code | GO (no blockers), many FLAGs | Input-heavy examples with missing guards, but no collapse constructs. |

Rule of thumb: BLOCK is rare and reserved for guarantee collapse. FLAG is common and
indicates governance review items.

## Production · Regulated · High BLOCK Conditions (NO-GO Justification)

Legacy Lens should justify BLOCK only when a construct collapses source-level
guarantees such that governance cannot approve modernization without assumptions.

### A) Control-Flow Guarantee Collapse (Always BLOCK)

- ALTER (self-modifying control flow).
- Computed or dependent GO TO where destinations are not statically bounded.
- Dynamic CALL with no provable finite target set.
- Entry-point ambiguity that prevents establishing authoritative start points.

### B) Dependency Collapse (Block When Material)

- Dynamic external dependencies that cannot be enumerated in regulated systems.
- Missing copybooks or includes that prevent proving regulated fields or control flow.

### C) Opaque Execution Dominance (Policy-Driven BLOCK)

- Programs dominated by opaque preprocessed blocks (EXEC SQL/CICS) without
  preexpanded sources when declared context requires proof inside those blocks.

### D) Irreducible Uncertainty Under Declared Governance Context

- Regulated or production systems where essential guarantees cannot be proven or
  bounded under the declared context.

## What Should Not Auto-Block (Default)

These are typically FLAG, not NO-GO by default:

- Missing FILE STATUS (unless declared context elevates to NO-GO).
- Missing ON SIZE ERROR (requires data bounds to justify block).
- Unconditional or backward GO TO (structural risk but analyzable).
- Portability findings (COMP-5, POINTER, NEXT SENTENCE).
- PII-like field present (evidence tag; governance interpretation required).

Legacy Lens proves facts. Declared context determines consequences.
