# CFO ROI Explainer
Why Legacy Lens Pays for Itself by Saying "No"

## Executive Summary
Legacy Lens reduces financial risk by preventing unjustified approvals during legacy modernization. Its value is not in speeding delivery, but in avoiding irreversible, high-cost mistakes that occur when systems are approved without provable guarantees.

## The Cost CFOs Actually Care About
Modernization failures do not show up as line items called "bad analysis." They appear as:
- rework and rollback costs
- extended parallel runs
- audit findings and corrective programs
- delayed go-lives and lost opportunity
- regulatory penalties and consent decrees
- post-migration incidents with legal exposure

These costs are order-of-magnitude larger than analysis products.

## What Legacy Lens Changes Financially
### 1. It Converts Hidden Risk into Visible Decisions
Legacy Lens turns undocumented behavior into explicit boundaries:
- what is provable
- what is not
- what must be isolated

This allows finance to:
- approve scoped investments
- avoid all-or-nothing rewrites
- fund corrective work only where it matters

Outcome: capital is deployed surgically, not blindly.

### 2. It Prevents False "Green Lights"
Most products optimize for approval. Legacy Lens optimizes for defensible refusal.

A single unjustified approval can cost:
- $5M to $20M in rework (large banks)
- $10M to $50M in delayed programs
- $100M+ in regulatory corrective programs over time

Outcome: one prevented bad approval can justify the authority for years.

### 3. It Enables Partial Approvals (Cash Flow Preservation)
Legacy Lens supports NO-GO outcomes with explicit scope:
- 85% to 95% of modules proceed
- 5% to 15% are isolated with explicit risk

This keeps programs moving without increasing risk.

## Quantified ROI Model (Conservative)
Typical regulated enterprise modernization:
- Program budget: $25M to $75M
- Failure/rework probability without forensic governance: 20% to 30%
- Expected loss exposure: $5M to $20M
- Legacy Lens cost: low single-digit percent of program cost

ROI is asymmetric: small, predictable cost; large avoided losses.

## Why This Is Not "Another Software Spend"
Legacy Lens is not a developer productivity system or a velocity accelerator. It is a risk control, like segregation of duties or change management.

Finance does not ask "what is the ROI of controls?" It asks "what happens if we do not have them?"

## Bottom Line for CFOs
Legacy Lens does not make modernization cheaper. It makes failure rarer, and failure is what is expensive.
