# Change Control Note — Registry v1.0.6

**Date:** 2026-01-05  
**Scope:** Detection Rule Precision  
**Registry Version:** v1.0.6  
**Status:** Closed

## Summary
Registry v1.0.6 corrects a precision regression in the evidence-grade rule
`SECURITY_PASSWORD_COMPARISON` identified during validation against the
NIST COBOL-85 test corpus.

The change improves semantic intent detection for credential comparisons
and eliminates false positives arising from test-harness PASS/FAIL logic.
No governance outcomes, boundary detection, or determinism properties were affected.

## What Changed
- Added explicit semantic gating to distinguish credential handling from test result checks.
- Suppressed comparisons against known test literals ("PASS", "FAIL", "OK") when no credential-indicative identifier is present.
- Added deterministic exclusions for known test-harness identifier patterns.

## What Did Not Change
- Evidence determinism (hashes remain reproducible).
- Tier-2 boundary detection and counts.
- Migration block rates.
- Governance outcomes (GO / NO-GO / REFUSE).
- Context handling or authority thresholds.

## Impact Assessment
- **Affected rule:** `SECURITY_PASSWORD_COMPARISON`
- **Impact type:** Evidence precision only
- **Authority impact:** None
- **Regulatory impact:** None

## Verification
- Re-analysis of NIST COBOL-85 produces zero findings for `SECURITY_PASSWORD_COMPARISON`.
- Tier-2 boundary counts remain unchanged.
- Governance outcome under Production · Regulated · High remains NO-GO.
- A golden CI assertion permanently enforces this behavior.

## Authority Statement
Legacy Lens treats evidence precision regressions as integrity issues.
Corrections are applied conservatively, verified deterministically, and protected against re-occurrence through locked registry releases and CI enforcement.

**This change is complete and closed.**
