# Contract Language - Standard-of-Proof and Authority Engagement

Placement: Master Services Agreement (MSA) + Order Form + Authority Engagement Addendum
Tone: Normative, defensive, cite-ready

## 1. Definitions (Add Verbatim)
"Standard of Proof" means the Legacy Lens Standard-of-Proof v1.0, as updated only by explicit versioned publication.

"Evidence" means immutable, deterministic artifacts generated from source-level analysis and anchored to file, line, snippet, and cryptographic hash.

"Governance Decision" means a context-bound determination (GO / NO-GO / REFUSE) issued in accordance with the Standard of Proof.

## 2. Scope of Services (Tight)
Legacy Lens provides deterministic evidence generation and governance decisioning solely as defined by the Standard of Proof. Legacy Lens does not perform runtime analysis, dynamic testing, or compliance certification.

## 3. Non-Claims (Mandatory)
Legacy Lens does not certify compliance, assert runtime behavior, guarantee security or safety, or replace audits, testing, or human judgment.

## 4. Determinism and Replayability
Analyses are deterministic. Identical inputs, configuration, rule registry, and Standard-of-Proof version produce bit-for-bit identical outputs. Evidence bundles are replayable and verifiable.

## 5. Evidence Tier Handling
Artifact evidence tiers constrain permissible claims. Mixed-artifact decisions inherit the lowest evidence tier involved. Opaque artifacts are recorded as irreducible uncertainty and are not inferred.

## 6. Governance Decisions and Refusal
Legacy Lens may refuse to issue a Governance Decision when proof requirements are not met. Refusal is a valid governance outcome.

## 7. Scope and Exclusions
Scope exclusions must be explicit, evidence-anchored, and recorded. Excluded artifacts remain unapproved; residual risk is stated.

## 8. Licensing Authority
License issuance is performed by Legacy Lens using offline signing. Customers receive signed artifacts for verification only. License expiration disables future decisions, not historical evidence.

## 9. Versioning Stability
Decisions reference the applicable Standard-of-Proof and rule registry versions. New versions do not reinterpret prior decisions.

## 10. Reliance
Customer may rely on Evidence and Governance Decisions only within the bounds of the Standard of Proof and declared context.

---

# Authority Engagement Addendum (External Decision Authority)

## A1. Scope of Services
Legacy Lens shall provide deterministic source-level analysis and produce an immutable evidence bundle for the defined scope and declared governance context.

## A2. Nature of Output
Outputs consist of evidence artifacts, boundary identification, and governance outcomes (GO / NO-GO / REFUSE). Outputs are context-bound and non-executive in nature.

## A3. No Certification or Approval
Legacy Lens does not certify compliance, assert runtime behavior, or guarantee safety. Legacy Lens issues governance decisions under declared context; the Client retains responsibility for operational approvals and execution.

## A4. Determinism and Replay
Outputs are deterministic and reproducible when inputs, registry version, and context are unchanged.

## A5. Evidence Persistence
Evidence bundles remain valid and auditable indefinitely. License expiration does not invalidate historical outputs.

## A6. Reliance
Client may reference Legacy Lens evidence and governance decisions as independent deterministic records within the declared context.

## A7. Limitation
Legacy Lens liability is limited to fees paid under this engagement. Outputs reflect evidence available at the time of analysis.
