# Evidence Tier Labels - Exact Text for UI and Reports

These labels are normative. They must appear wherever evidence records are referenced (engineering evidence record, regulatory evidence packet, evidence bundle). They must not appear in board decision records or executive decision summaries.

## Evidence Tier: HIGH (COBOL)
Meaning
- Evidence and guarantees are derived directly from source-level COBOL semantics and evaluated deterministically under the active rule registry.

Implications
- Guarantees may be asserted where provable.
- BLOCK decisions may be issued on guarantee collapse.
- Findings are suitable for governance decisions under declared context.

Limitations
- No runtime behavior is inferred.
- No compliance or security certification is implied.

## Evidence Tier: MEDIUM (PL/I)
Meaning
- Evidence is derived from a restricted subset of PL/I semantics. Compiler-dependent or ambiguous constructs are treated as opaque.

Implications
- Guarantees may be asserted only for explicitly supported constructs.
- BLOCK decisions are rare and limited to provability collapse equivalent to COBOL (e.g., unbounded control flow).
- Findings require additional scrutiny in regulated contexts.

Limitations
- Evidence tier is lower than COBOL.
- Unsupported semantics are explicitly recorded as opaque.

## Evidence Tier: LOW (CICS / IMS / Assembler)
Meaning
- Artifacts are recorded as execution boundaries or opaque regions. No semantic reasoning is performed.

Implications
- Evidence reflects presence, structure, or boundaries only.
- Guarantees are not asserted.
- Decisions may be affected by declared context when irreducible uncertainty is material.

Limitations
- No runtime behavior is inferred.
- No transaction integrity, safety, or compliance claims are made.

## Evidence Tier: STRUCTURAL (JCL)
Meaning
- JCL is analyzed as orchestration metadata only.

Implications
- Structural relationships and dependencies may be recorded.
- No execution ordering, scheduling, or dataset lifecycle semantics are inferred.

Limitations
- JCL does not contribute to guarantees or BLOCK decisions directly.

## Mandatory UI Rule
The lowest evidence tier involved constrains the strength of the overall decision. Evidence tiers are not displayed in board or executive artifacts.
