# PDF-Ready Layout Guides

These layout guides are conservative and audit-friendly. They are designed to be printable, citable, and stable.

## A) Standard-of-Proof v1.0 - PDF Layout
Document Class: Normative / Binding
Intended Readers: Audit, Legal, Board, Regulators
Length: 8-10 pages max

Cover Page
- Legacy Lens
- Standard of Proof v1.0
- Deterministic Forensic Governance for Legacy Systems
- Version: v1.0
- Effective Date: {{date}}
- Supersedes: None
- Status: Normative
- This document defines the conditions under which Legacy Lens may assert evidence or issue governance decisions.

Page 1 - Authority Statement (must be first)
Statement of Authority
- Legacy Lens issues governance decisions only under the conditions defined in this Standard of Proof.
- Any output outside these bounds is invalid.
- This Standard is referenced by evidence bundles, governance reports, and board summaries.

Page 2 - Determinism and Non-Claims
- Determinism Requirement (exact text from Standard-of-Proof v1.0)
- Explicit Non-Claims (exact list from Standard-of-Proof v1.0)

Page 3 - Evidence vs Guarantee
Two boxed sections:
- Evidence: file, line, snippet, hash, immutable
- Guarantee: exists only if provable from source; absence of proof recorded explicitly

Page 4 - Artifact Evidence Tier Model (table page)
Centered table (full width):
Artifact | Mode | Proof Domain | Can BLOCK | Evidence Tier
COBOL | Full | Source semantics | Yes | High
PL/I | Partial | Restricted semantics | Yes (rare) | Medium
JCL | Metadata | Structural only | No | N/A
CICS / IMS | Opaque | Runtime boundary | Policy | Low
Assembler | Opaque | None | Never alone | Low

Below table (boxed):
Rule: The lowest evidence tier constrains the strength of the overall decision.

Page 5 - Opaque Boundary Rules
Bullet-tight rules:
- no inference
- no extrapolation
- no reclassification
- explicit uncertainty

Short example:
CICS transaction detected -> recorded as opaque boundary -> no runtime claim issued.

Page 6 - Decision Boundary Doctrine
List of deterministic boundary triggers:
- unbounded dynamic control flow
- self-modifying logic
- unresolved execution targets
- dominant opaque regions under high-provability context

Statement:
Boundary evidence terminates deterministic guarantees.

Page 7 - Scope and Exclusion Doctrine
- scope may be reduced
- exclusions must be explicit
- residual risk remains

This page documents scoped NO-GO outcomes clearly.

Page 8 - Decision Issuance and Re-Evaluation
Decision rules:
- license valid
- context declared
- evidence tier satisfied

Re-evaluation requires:
- new evidence OR
- new context

No retroactive reinterpretation.

Final Page - Statement of Record
This Standard defines the conditions under which Legacy Lens may assert evidence or issue governance decisions. Claims beyond these bounds are explicitly disallowed.

## B) Board Decision Record - PDF Layout
Document Class: Executive / Governance
Length: 1 page + appendices

Page 1 - Board Summary (no scrolling)
- Decision (GO / NO-GO / REFUSE)
- Declared Governance Context
- Rationale (fixed language)
- Evidence Reference (bundle ID, registry version, bundle root hash)
- Authority Statement (footer)

No appendices.
