# Procurement FAQ
Legacy Lens - Independent Deterministic Decision Authority

Audience: Procurement, Legal, Risk, Vendor Management

## 1. "Why doesn't Legacy Lens just approve the system like other approaches?"
Because approval without proof creates liability. Legacy Lens issues governance decisions only when guarantees can be proven from source. Where proof collapses, refusal is the responsible outcome.

## 2. "Other vendors say this code is safe. Why are you stricter?"
Legacy Lens does not infer runtime behavior or rely on undocumented assumptions. Other vendors may provide opinions or heuristics. Legacy Lens provides deterministic evidence and records uncertainty explicitly.

## 3. "Does a NO-GO mean the system is broken or non-compliant?"
No. A NO-GO indicates that equivalence cannot be proven under the declared governance context. It is not a runtime defect, incident, or compliance determination.

## 4. "Can we suppress findings to get a GO?"
No. Scope exclusions must be explicit, evidence-anchored, and recorded. Suppression does not reclassify excluded artifacts as safe or approved.

## 5. "Why can't Legacy Lens analyze everything (CICS, IMS, assembler)?"
Legacy Lens analyzes only what can be proven deterministically from source. Runtime-defined behavior and assembler semantics are treated as opaque boundaries. This avoids false assurance.

## 6. "Does Legacy Lens certify PCI, SOX, or regulatory compliance?"
No. Legacy Lens does not certify compliance. It produces evidence that auditors and regulators may use as part of their assessments.

## 7. "What happens when the license expires?"
License expiration disables future governance decisions. Historical evidence and decisions remain valid, replayable, and auditable.

## 8. "How can we evaluate Legacy Lens before engagement?"
Legacy Lens provides an Evidence / Evaluation License. This enables evidence-only analysis, deterministic replay, and boundary inspection. It does not permit governance context declaration, GO / NO-GO decisions, or board decision records/executive decision summaries.

## 9. "Can results be reproduced independently?"
Yes. Analyses are deterministic. Identical inputs, rule registry, and Standard-of-Proof version produce identical outputs and hashes.

## 10. "Why is Legacy Lens offline?"
Offline operation ensures determinism, prevents data leakage, and preserves evidentiary integrity. It also supports air-gapped and regulated environments.

## 11. "How does Legacy Lens reduce risk for us as a buyer?"
By refusing to approve when proof is absent, Legacy Lens prevents irreversible decisions based on assumption. This reduces legal, regulatory, and operational risk.

## 12. "Isn't this overly conservative?"
Conservatism is intentional. In high-impact environments, refusing to guess is safer than approving prematurely. Legacy Lens enables progress through scoped approvals and explicit boundaries.

## 13. "Why should we pay for an authority that sometimes says no?"
Because the cost of an unjustified approval is materially higher than the cost of refusal. Legacy Lens provides defensible decision boundaries that protect the organization.

## 14. "Can we use Legacy Lens only for certain systems?"
Yes. Governance context and scope are declared per analysis. Partial approvals and scoped decisions are supported and recorded explicitly.

## 15. "Is Legacy Lens replacing our auditors or consultants?"
No. Legacy Lens issues or refuses governance decisions for the declared scope. Auditors, consultants, and governance bodies may cite the decision record but do not replace it.

## 16. "What makes Legacy Lens different from static analysis products?"
Legacy Lens is not a code quality or vulnerability product. It is a forensic authority focused on provable guarantees and governance decisions.

## Statement of Record
Legacy Lens is an independent deterministic authority used to support or refuse regulated decisions involving legacy systems. It produces replayable forensic evidence and issues decisions only when guarantees can be proven under a declared governance context.
Legacy Lens does not certify compliance or infer runtime behavior.
