# Appendix R - Deterministic Evidence and Governance Methodology

## Purpose
This appendix describes how Legacy Lens produces deterministic evidence and issues governance decisions without asserting runtime behavior or compliance.

## Deterministic Operation
Legacy Lens executes offline and deterministically. Identical inputs and configuration produce identical outputs, including cryptographic hashes.

## Evidence Methodology
Evidence is derived exclusively from source-level artifacts and anchored to file, line, snippet, and hash. Evidence is immutable once recorded.

## Guarantee Model
A guarantee is asserted only when it can be proven from source without assumption. When proof is not possible, the absence of guarantee is recorded explicitly.

## Opaque Boundaries
Artifacts whose behavior is runtime-defined (e.g., transaction managers, assembler routines) are treated as opaque boundaries. No semantic inference is performed.

## Governance Decisions
Decisions are issued only under declared governance context and may be refused when provability collapses. Refusal to decide is a valid governance outcome.

## Scope and Exclusions
Scope exclusions are explicitly recorded. Excluded artifacts remain unapproved, and residual risk is stated.

## Non-Claims
Legacy Lens does not certify compliance, assert runtime correctness, or guarantee security or safety.

## Auditability
All outputs are replayable, verifiable, and traceable to a specific Standard-of-Proof version and rule registry.

## Statement of Record
This appendix documents the deterministic methodology under which governance decisions are issued or refused. It does not assert outcomes beyond the scope defined herein.
