# Legacy Lens Standard of Proof v1.0

Status: Normative
Applies to: All Legacy Lens analyses and decisions
Effective: Upon publication
Supersedes: None

## 1. Purpose
The purpose of this document is to define the conditions under which Legacy Lens may:

- assert evidence
- refuse evidence
- issue or refuse governance decisions

This Standard of Proof establishes the minimum evidentiary bar required for Legacy Lens outputs to be relied upon in governance, audit, regulatory, and executive decision-making contexts.

## 2. Scope
This Standard of Proof applies to:

- source-level analysis of legacy systems
- deterministic evidence generation
- governance decision issuance (GO / NO-GO / REFUSE)
- artifact coverage across supported languages and environments

This Standard of Proof does not apply to:

- runtime execution
- dynamic testing
- operational monitoring
- performance benchmarking
- compliance certification

## 3. Non-Goals (Explicit)
Legacy Lens does not:

- assert runtime behavior or execution correctness
- certify compliance with laws, regulations, or standards
- guarantee security, safety, or correctness
- replace testing, audits, or human judgment
- infer behavior not provable from source

Any interpretation beyond these bounds is out of scope.

## 4. Determinism Requirement
All Legacy Lens analyses must be deterministic.

Given identical:

- source inputs
- configuration
- rule registry
- Standard-of-Proof version

the following outputs must be bit-for-bit identical:

- findings
- discards
- evidence bundles
- hashes
- governance outcomes

A violation of determinism invalidates the analysis.

## 5. Evidence vs Guarantee
### 5.1 Evidence
Evidence is the verifiable presence or absence of a construct or property at the source level, anchored to:

- file
- line
- snippet
- cryptographic hash

Evidence is immutable once recorded.

### 5.2 Guarantee
A guarantee exists only if it can be proven from source without assumption.

If a guarantee cannot be proven, its absence must be recorded explicitly.

Absence of proof is not proof of absence.

## 6. Artifact Evidence Tiers
Legacy Lens classifies artifacts by evidence tier, which constrains the strength of permissible claims.

| Artifact | Mode | Proof Domain | Can Trigger BLOCK | Evidence Tier |
| --- | --- | --- | --- | --- |
| COBOL | Full Proof | Source-level semantics | Yes | High |
| PL/I | Partial Proof | Restricted semantics | Yes (rare) | Medium |
| JCL | Metadata Only | Structural inventory | No | N/A |
| CICS / IMS | Opaque Boundary | Runtime boundary only | Policy-driven | Low |
| Assembler | Opaque Only | None | Never alone | Low |

Rules:

- evidence tier labels are mandatory in evidence records and engineering artifacts; board and executive summaries omit tiers
- lower evidence tiers may not produce stronger claims
- mixed-artifact decisions inherit the lowest evidence tier involved
- this table is frozen per version

## 7. Opaque Boundaries
An artifact or construct is classified as OPAQUE when:

- semantics are runtime-defined
- behavior depends on external systems
- source does not encode execution meaning

Opaque handling rules:

- no inference is permitted
- no extrapolation is permitted
- no reclassification as "safe" is permitted
- opaqueness must be recorded explicitly

Opaque does not mean ignored. Opaque means irreducible uncertainty.

## 8. Governance Gates
Governance decisions are evaluated through deterministic gates.

### 8.1 BLOCK Conditions
A BLOCK may be issued only when provable guarantees collapse, including:

- unbounded dynamic control flow
- self-modifying logic
- unresolved execution targets
- dominant opaque regions under contexts requiring provability

Each BLOCK must cite the collapse category and evidence reference.

### 8.2 FLAG Conditions
FLAGs are used for:

- missing guards
- portability risks
- audit-relevant constructs
- context-review items

FLAGs do not prevent decisions unless elevated by declared context.

## 9. Scope and Exclusion Doctrine
Scope adjustments are permitted only if:

- exclusions are explicit
- reasons are evidence-anchored
- residual risk is stated

Excluded artifacts remain unapproved. Scope changes never reclassify excluded artifacts as safe.

## 10. Decision Issuance Rules
A governance decision may be issued only when:

- a valid license is present
- governance context is declared
- applicable artifacts meet evidence tier requirements

Decisions are:

- context-bound
- time-bound
- non-retroactive

## 11. Re-Evaluation Rules
Re-evaluation requires:

- new evidence, or
- a new declared governance context

Historical decisions remain valid records and are not reinterpreted.

## 12. Versioning and Stability
Every decision references:

- Standard-of-Proof version
- rule registry version

New versions of this Standard do not reinterpret prior decisions.

## 13. Statement of Authority
Legacy Lens may refuse to issue a decision when proof requirements are not met.

Such refusal is a valid governance outcome.

## 14. Final Lock-In
Expansion must add visibility before it adds authority. Proof must always lag evidence.

## Statement of Record
This Standard of Proof defines the conditions under which Legacy Lens may assert evidence and issue governance decisions. Claims outside these bounds are explicitly disallowed.
