# Why Legacy Lens Refuses
Deterministic governance requires saying "no" when proof collapses.

Legacy Lens is designed to refuse governance approval when guarantees cannot be proven from source.
This is intentional.

## What Refusal Means
A refusal (REFUSE or NO-GO) indicates that provable guarantees terminate under the declared governance context.

It does not mean:
- the system is broken
- a runtime incident exists
- modernization is impossible
- compliance has failed

It means equivalence cannot be asserted without assumptions.
Legacy Lens does not approve based on assumption.

## Why Refusal Is Necessary
Legacy systems often rely on:
- runtime defaults
- environment-specific behavior
- implicit error handling
- undocumented control flow

These behaviors may be stable on the original platform but are not encoded in source.
When systems are migrated or re-platformed, those assumptions break.

Legacy Lens refuses approval where:
- error paths are implicit (example: missing CICS RESP handling)
- control flow is dynamic or self-modifying
- execution targets are unresolved
- behavior depends on runtime configuration

Approving under these conditions would require guessing.

## What Legacy Lens Does Instead
Legacy Lens provides:
- deterministic, replayable evidence
- explicit identification of guarantee boundaries
- conservative decisioning under declared context
- scope isolation where appropriate

Where proof exists, Legacy Lens approves.
Where proof collapses, Legacy Lens records uncertainty and refuses to guess.

## How This Enables Progress
Refusal does not block modernization.
It defines a safe boundary for it.

Common outcomes include:
- NO-GO with scoped impact documented for affected modules
- scope isolation of high-risk components
- evidence-driven scope changes or new evidence
- re-evaluation under a different governance context

This enables forward progress without misrepresentation.

## Principle
If behavior cannot be proven from source, it cannot be approved without assumption.
Legacy Lens does not approve based on assumption.

## Statement of Record
Legacy Lens governance decisions are issued only under declared context and in accordance with the Legacy Lens Standard of Proof.
Refusal to issue a decision reflects the absence of provable guarantees and is an intentional design outcome.
